/***************************************************************************
**
**  This file is part of QGpGuiTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2011-01-05
**  Copyright: 2011-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include <QJSEngine>

#include "HttpProxyScript.h"
#include "HttpProxyObject.h"

namespace QGpGuiTools {

  /*!
    \class HttpProxyScript HttpProxyScript.h
    \brief Brief description of class still missing

    Specifications from https://calomel.org/proxy_auto_config.html.
    Helpful information at http://findproxyforurl.com.
    dateRange() and timeRange() inspired from pac_utils.js shipped with pactester
    (http://code.google.com/p/pactester).
  */

  /*!
    Description of constructor still missing
  */
  HttpProxyScript::HttpProxyScript(const QString& content)
  {
    TRACE;
    _script=content;
    _engine=new QJSEngine;
    QJSValue extension=_engine->newQObject(new HttpProxyObject);

    _engine->globalObject().setProperty("isPlainHostName", extension.property("isPlainHostName"));
    _engine->globalObject().setProperty("dnsDomainIs", extension.property("dnsDomainIs"));
    _engine->globalObject().setProperty("localHostOrDomainIs", extension.property("localHostOrDomainIs"));
    _engine->globalObject().setProperty("isResolvable", extension.property("isResolvable"));
    _engine->globalObject().setProperty("isInNet", extension.property("isInNet"));
    _engine->globalObject().setProperty("dnsResolve", extension.property("dnsResolve"));
    _engine->globalObject().setProperty("myIpAddress", extension.property("myIpAddress"));
    _engine->globalObject().setProperty("dnsDomainLevels", extension.property("dnsDomainLevels"));
    _engine->globalObject().setProperty("shExpMatch", extension.property("shExpMatch"));
    _engine->globalObject().setProperty("weekdayRange", extension.property("weekdayRange"));
    _engine->globalObject().setProperty("dateRange", extension.property("dateRange"));
    _engine->globalObject().setProperty("timeRange", extension.property("timeRange"));
  }

  /*!
    Description of destructor still missing
  */
  HttpProxyScript::~HttpProxyScript()
  {
    TRACE;
    delete _engine;
  }

  QList<HttpProxy> HttpProxyScript::proxies(const QUrl& url)
  {
    TRACE;
    QList<HttpProxy> list;
    QString script(_script);
    script+=QString("\nFindProxyForURL(\"%1\", \"%2\");").arg(url.toString()).arg(url.host());
    QJSValue result=_engine->evaluate(script);
    if(!result.isError()) {
      QStringList entries=result.toString().split(";");
      foreach(QString entry, entries) {
        entry=entry.trimmed();
        if(entry.startsWith("PROXY")) {
          list.append(HttpProxy(entry.mid(6)));
        } else if(entry.startsWith("DIRECT")) {
          list.append(HttpProxy());
        }
      }
    }
    return list;
  }

} // namespace QGpGuiTools
