/***************************************************************************
**
**  This file is part of QGpGuiTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2011-01-03
**  Copyright: 2011-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef HTTPPROXY_H
#define HTTPPROXY_H

#include <QGpCoreTools.h>

#include "QGpGuiToolsDLLExport.h"

class QNetworkProxy;

namespace QGpGuiTools {

  class QGPGUITOOLS_EXPORT HttpProxy
  {
  public:
    HttpProxy();
    HttpProxy(QString url);
    HttpProxy(const QNetworkProxy& proxy);
    HttpProxy(const HttpProxy& o);
    ~HttpProxy();

    void operator=(const HttpProxy& o);
    bool operator==(const HttpProxy& o) const;
    bool operator<(const HttpProxy& o) const;

    const QNetworkProxy& proxy() const;

    void printDebug(QTextStream& s) const;
  private:
    static int compareProxies(const QNetworkProxy& p1, const QNetworkProxy& p2);

    QNetworkProxy * _proxy;
  };

} // namespace QGpGuiTools

#endif // HTTPPROXY_H
