/***************************************************************************
**
**  This file is part of QGpGuiTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2010-12-07
**  Copyright: 2010-2019
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef HTTPACCESS_H
#define HTTPACCESS_H

#include <QtCore>

#include "QGpGuiToolsDLLExport.h"

class QNetworkReply;
class QNetworkProxy;

namespace QGpGuiTools {

  class HttpProxyList;

  class QGPGUITOOLS_EXPORT HttpAccess : public QObject
  {
    Q_OBJECT
  public:
    HttpAccess(const QString& testUrl, QObject * parent=nullptr);
    ~HttpAccess();

    static bool isAvailable();
    bool isReady() const {return _proxy;}
    void get(const QUrl& url);
    void post(const QUrl& url, const QByteArray& data);

    const QByteArray& receivedData() const {return _receivedData;}
  private slots:
    void requestFinished();
    void testProxies();
    void testFinished();
  signals:
    void ready();
    void finished(bool ok);
  private:

    QByteArray _receivedData;
    QNetworkProxy * _proxy;
    HttpProxyList * _proxies;
    QList<QNetworkReply *> _testReplies;
  };

} // namespace QGpGuiTools

#endif // HTTPACCESS_H
