/***************************************************************************
**
**  This file is part of QGpCoreTools.
**
**  QGpCoreTools is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpCoreTools is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2020-02-18
**  Copyright: 2020
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef ABSTRACTTASK_H
#define ABSTRACTTASK_H

#include "QGpCoreToolsDLLExport.h"
#include "Mutex.h"

#define TASK_TIMING

namespace QGpCoreTools {

  class TaskManager;

  class QGPCORETOOLS_EXPORT AbstractTask : public QObject
  {
    Q_OBJECT
  public:
    AbstractTask(TaskManager * parent, int taskIndex);
    ~AbstractTask();

    int taskIndex() const {return _taskIndex;}

    void setStepCount(int sc) {_stepCount=sc;}
    int currentStep() const {return _currentStep;}
    void addSteps(int count) {_currentStep+=count;}

    void lock() {_mutex.lock();}
    bool tryLock() {return _mutex.tryLock();}
    void unlock() {_mutex.unlock();}

    virtual void init();
    void beginProcess() {_processCount++;}
    void endProcess();
    bool isRunning() const {return _processCount>0;}

    bool hasStepToProcess() const {return _currentStep<_stepCount;}
    void setFinishing();
    bool isFinishing() const {return _maxStep>=_stepCount;}
    virtual void polish() {}

    TaskManager * taskManager() const;
  signals:
    void statusChanged(int taskIndex, QString msg);
    void progressInit(int taskIndex, int maximumValue);
    void progressChanged(int taskIndex, int value);
  private:
    int _taskIndex;
    int _currentStep, _stepCount, _maxStep;
    int _processCount;
    Mutex _mutex;
#ifdef TASK_TIMING
    QElapsedTimer _chrono;
    int _processTime;
#endif
  };

} // namespace QGpCoreTools

#endif // ABSTRACTTASK_H

