/***************************************************************************
**
**  This file is part of QGpCoreMath.
**
**  QGpCoreTools is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpCoreTools is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2020-02-18
**  Copyright: 2020
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef XUNIQUEYCOLORDATA_H
#define XUNIQUEYCOLORDATA_H

#include "QGpCoreMathDLLExport.h"
#include "Color.h"
#include "Rect.h"

namespace QGpCoreMath {

  class QGPCOREMATH_EXPORT XUniqueYColorData
  {
  public:
    XUniqueYColorData();
    ~XUniqueYColorData();

    void clear();
    void setPointCount(int nCurve, int nX);

    const double * x() const {return _x;}
    const double * y() const {return _y;}
    double * x() {return _x;}
    double * y() {return _y;}

    const Color * colors() const {return _colors;}
    void setColors(Color * col);
    void setColor(int index, const Color& col) {_colors[index]=col;}

    Rect boundingRect() const;
    QVector<int> * inside(const Rect& r);

    int curveCount() {return _curveCount;}
    int xCount() {return _xCount;}

    void toStream(QDataStream& s) const;
    bool fromStream(QDataStream& s, const Version * fileVersion=nullptr);

    static void saveColors(QDataStream& s, Color * colors, int count);
    static void restoreColors(QDataStream& s, Color *& colors, int count,
                              const Version * fileVersion=nullptr);
  private:
    int _curveCount;
    int _xCount;
    double * _x;
    double * _y;
    Color * _colors;
  };

} // namespace QGpCoreMath

#endif // XUNIQUEYCOLORDATA_H

