/***************************************************************************
**
**  This file is part of QGpCoreMath.
**
**  QGpCoreMath is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpCoreMath is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2020-04-02
**  Copyright: 2020
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef WINDOWFUNCTION_H
#define WINDOWFUNCTION_H

#include "QGpCoreMathDLLExport.h"
#include "WindowFunctionParameters.h"

namespace QGpCoreMath {

  class QGPCOREMATH_EXPORT WindowFunction
  {
  public:
    WindowFunction(int n, const WindowFunctionParameters& param);
    ~WindowFunction();

    QString actionToString() const;
    QString toString() const;

    void setSignalRange(int beginIndex, int endIndex);
    void setStartIndex(int beginIndex);
    double correctionFactor() const;

    class Action
    {
    public:
      enum Type {Vanish, Untouch, Multiply};

      inline Action(Type t=Vanish, int startIndex=0, int endIndex=0);

      void add(int index) {_startIndex+=index; _endIndex+=index;}

      void setStart(int index) {_startIndex=index;}
      int start() const {return _startIndex;}

      void setEnd(int index) {_endIndex=index;}
      int end() const {return _endIndex;}

      Type type() const {return _type;}

      QString toString() const;
    private:
      Type _type;
      int _startIndex, _endIndex;
    };

    const QVector<Action>& actions() const {return _actions;}
    double value(int index) const {return _dataPtr[index];}
    static double value(double x, double x0, double xMin, double xMax,
                        const WindowFunctionParameters& param);
    static bool check();
  private:
    static double konnoOhmachiExponent(double xMin, double xMax);
    static double parzen(double x, const double& invl2, const double& l4);
    void initActions(bool reversed);

    int _N;
    double * _data, * _dataPtr;
    QVector<Action> _actions;
  };

   inline WindowFunction::Action::Action(Type t, int startIndex, int endIndex)
   {
     _type=t;
     _startIndex=startIndex;
     _endIndex=endIndex;
   }

} // namespace QGpCoreMath

#endif // WINDOWFUNCTION_H

