/***************************************************************************
**
**  This file is part of QGpCoreMath.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2009-04-11
**  Copyright: 2009-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "ComplexExponential.h"

namespace QGpCoreMath {

/*!
  \class ComplexExponential ComplexExponential.h
  \brief Fast computation of complex exponential with a rational argument

  Compute values of expression exp(2*pi*i*x/n), 0<x, i is the imaginary number.
  As x and n are integers, this expression has a maximum of n distinct values,
  even if x is not limited to n (by periodic properties).

  This object was first designed for the computation fast partial Fourier transform
  where a lot of redundant computation of this exponential are required. All values
  are kept in a cache of dimension n.
*/

/*!
  Description of constructor still missing
*/
ComplexExponential::ComplexExponential(int n, Sign s)
{
  _s=s;
  _n=n;
  _cache=new Complex[_n];
  _invn=1.0/(double)_n;
}

/*!
  Description of destructor still missing
*/
ComplexExponential::~ComplexExponential()
{
  delete [] _cache;
}

} // namespace QGpCoreMath
