/***************************************************************************
**
**  This file is part of HVGui.
**
**  HVGui is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  HVGui is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2020-05-25
**  Copyright: 2020
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef ROTATERESULTWIDGET_H
#define ROTATERESULTWIDGET_H

#include "AbstractResultWidget.h"
#include "HVGuiDLLExport.h"

namespace HVGui {

  class HVGUI_EXPORT RotateResultWidget : public AbstractResultWidget
  {
  public:
    RotateResultWidget(QWidget * parent=nullptr);
    ~RotateResultWidget();

    RotateResults * values() const {return static_cast<RotateResults *>(_values);}
    void showValues();

    void restoreMakeUp(const QString& fileName);
    void setLimits(const SamplingParameters& x);

    IrregularGrid2DPlot * gridLayer() const {return _gridLayer;}
  private:
    IrregularGrid2DPlot * _gridLayer;
  };

} // namespace HVGui

#endif // ROTATERESULTWIDGET_H

