/***************************************************************************
**
**  This file is part of HVGui.
**
**  HVGui is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  HVGui is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2005-10-10
**  Copyright: 2005-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef PEAKSEARCHRANGE_H
#define PEAKSEARCHRANGE_H

#include <QGpGuiTools.h>

#include "ui_PeakSearchRange.h"
#include "HVGuiDLLExport.h"

namespace HVGui {

  class HVGUI_EXPORT PeakSearchRange : public Dialog, private Ui::PeakSearchRange
  {
    Q_OBJECT
  public:
    PeakSearchRange(QWidget *parent=nullptr, Qt::WindowFlags f=Qt::Widget);

    double minimum() const {return fromFrequency->value();}
    double maximum() const {return toFrequency->value();}
  };

} // namespace HVGui

#endif // PEAKSEARCHRANGE_H
