/***************************************************************************
**
**  This file is part of HVGui.
**
**  HVGui is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  HVGui is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2011-01-29
**  Copyright: 2011-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "PeakEditor.h"
#include "AbstractPeakModel.h"
#include "PeakSearchRange.h"

namespace HVGui {

  /*!
    \class PeakEditor PeakEditor.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    Description of constructor still missing
  */
  PeakEditor::PeakEditor(QWidget * parent)
    : QWidget(parent)
  {
    TRACE;
    setupUi(this);
    selector->setView(peakTable);
  }

  /*!
    Description of destructor still missing
  */
  PeakEditor::~PeakEditor()
  {
    TRACE;
    Settings::setColumnWidth(peakTable, "PeakEditorTable");
  }

  void PeakEditor::setModel(AbstractPeakModel * m)
  {
    TRACE;
    peakTable->setModel(m);
    peakTable->setSelectionBehavior(QAbstractItemView::SelectRows);
    peakTable->setSelectionMode(QAbstractItemView::ExtendedSelection);
    Settings::columnWidth(peakTable, "PeakEditorTable");
  }

  void PeakEditor::on_addButton_clicked()
  {
    TRACE;
    PeakSearchRange * d=new PeakSearchRange(this);
    Settings::getWidget(d);
    if(d->exec()==QDialog::Accepted) {
      Settings::setWidget(d);
      AbstractPeakModel * model=static_cast<AbstractPeakModel *>(peakTable->model());
      model->add(d->minimum(), d->maximum());
      emit touched();
    }
    delete d;
  }

  void PeakEditor::on_adjustButton_clicked()
  {
    TRACE;
    PeakSearchRange * d=new PeakSearchRange(this);
    Settings::getWidget(d);
    if(d->exec()==QDialog::Accepted) {
      Settings::setWidget(d);
      double min=d->minimum();
      double max=d->maximum();
      AbstractPeakModel * model=static_cast<AbstractPeakModel *>(peakTable->model());
      QItemSelectionModel * sel=peakTable->selectionModel();
      QModelIndexList r=sel->selectedRows();
      for(QModelIndexList::iterator it=r.begin(); it!=r.end(); it++) {
        model->adjust(it->row(), min, max);
      }
      emit touched();
    }
    delete d;
  }

  void PeakEditor::on_removeButton_clicked()
  {
    TRACE;
    AbstractPeakModel * model=static_cast<AbstractPeakModel *>(peakTable->model());
    QItemSelectionModel * sel=peakTable->selectionModel();
    QModelIndexList r=sel->selectedRows();
    for(QModelIndexList::iterator it=r.begin(); it!=r.end(); it++) {
      model->remove(it->row());
    }
    emit touched();
  }

  void PeakEditor::on_saveButton_clicked()
  {
    TRACE;
    QString fileName=Message::getSaveFileName(tr("Save peaks"), tr("Peak file (*)"));
    if(!fileName.isEmpty()) {
      QFile f(fileName);
      if(!f.open(QIODevice::WriteOnly)) {
        Message::warning(MSG_ID, tr("Saving peaks ..."),
                         tr("Cannot write to file %1").arg(fileName), Message::cancel());
        return;
      }
      QTextStream s(&f);
      AbstractPeakModel * model=static_cast<AbstractPeakModel *>(peakTable->model());
      QItemSelectionModel * sel=peakTable->selectionModel();
      QModelIndexList r=sel->selectedRows();
      for(QModelIndexList::iterator it=r.begin(); it!=r.end(); it++) {
        model->save(s, it->row());
      }
    }
  }

} // namespace HVGui
