/***************************************************************************
**
**  This file is part of HVGui.
**
**  HVGui is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  HVGui is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2005-10-10
**  Copyright: 2005-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef CURVERESULTSHEETOPTIONS_H
#define CURVERESULTSHEETOPTIONS_H

#include <QtGui>

#include "ui_CurveResultSheetOptions.h"
#include "HVGuiDLLExport.h"

namespace HVGui {

  class CurveResultWidget;

  class HVGUI_EXPORT CurveResultSheetOptions : public QWidget, public Ui::CurveResultSheetOptions
  {
    Q_OBJECT
  public:
    CurveResultSheetOptions(QWidget *parent=nullptr, Qt::WindowFlags f=Qt::Widget);

    void visibleLayers(const CurveResultWidget * r) const;
    void setVisibleLayers(const CurveResultWidget * sr);
    int visibleLayers() const;
    void setVisibleLayers(const int v);
  private:
    QCheckBox * checkBox(int iLayer) const;
    void setChecked(int ilayer, bool visible);
    bool isChecked(int ilayer) const;
  };

} // namespace HVGui

#endif // CURVERESULTSHEETOPTIONS_H
