/***************************************************************************
**
**  This file is part of HVGui.
**
**  HVGui is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  HVGui is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2020-05-25
**  Copyright: 2020
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef CURVERESULTSHEET_H
#define CURVERESULTSHEET_H

#include "AbstractResultSheet.h"
#include "HVGuiDLLExport.h"

namespace HVGui {

  class HVGUI_EXPORT CurveResultSheet : public AbstractResultSheet
  {
    Q_OBJECT
  public:
    CurveResultSheet(QWidget * parent=nullptr);
    ~CurveResultSheet();

    void addActions();
    void setLimits(double maxAmplitude);
  protected slots:
    virtual void loadResults()=0;
    void options();
    void editPeaks();
    void setPeaks();
    void studentTest();
    void filterWindows();
  signals:
    void peakChanged();
  protected:
    AbstractResultWidget * createWidget();
    void loadResults(QStringList fileNames);
  };

} // namespace HVGui

#endif // CURVERESULTSHEET_H

