/***************************************************************************
**
**  This file is part of HVCore.
**
**  HVCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  HVCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2020-02-20
**  Copyright: 2020
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "HVTool.h"
#include "HVStation.h"
#include "CurveResults.h"

namespace HVCore {

  /*!
    \class HVTool HVTool.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    Description of constructor still missing
  */
  HVTool::HVTool(QObject * parent)
    : AbstractHVTool(parent)
  {
    TRACE;
  }

  bool HVTool::setSubPool(SubSignalPool * subPool)
  {
    TRACE;
    if(!AbstractHVTool::setSubPool(subPool)) {
      return false;
    }
    if(!_stationSignals.addSignals(subPool) ||
       !_stationSignals.hasAllComponents() ||
       _stationSignals.components()!=StationSignals::AllComponent) {
      if(_stationSignals.components()!=StationSignals::AllComponent) {
        App::log(tr("Detected less than 3 components\n"));
      }
      return false;
    }
    setStations();
    return true;
  }

  AbstractStation * HVTool::createStation(StationSignals * sigs)
  {
    return new HVStation(sigs);
  }

} // namespace HVCore

