/***************************************************************************
**
**  This file is part of GeopsyGui.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2005-09-13
**  Copyright: 2005-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef WINDOWINGPARAMETERWIDGET_H
#define WINDOWINGPARAMETERWIDGET_H

#include <QtGui>
#include <GeopsyCore.h>

#include "ui_WindowingParameterWidget.h"
#include "GeopsyGuiDLLExport.h"
#include "FilterParameterWidget.h"

namespace GeopsyGui {

  class FilterParameterWidget;

  class GEOPSYGUI_EXPORT WindowingParameterWidget : public QWidget, private Ui::WindowingParameterWidget
  {
    Q_OBJECT
  public:
    WindowingParameterWidget(QWidget *parent=nullptr, Qt::WindowFlags f=Qt::Widget);

    void removeFilterOption();
    void removeFreqDepOption();

    void clear();
    void addComponent(QString name);
    void addStation(QString name);

    void setLength(WindowingParameters::LengthType t, double min, double max=0.0);

    void getParameters(WindowingParameters & param) const;
    void setParameters(const WindowingParameters & param);

    void createSelectMenu(QToolButton * select);
    bool isAddWindowsManually() const {return _addWindowsAction->isChecked();}
    bool isRemoveWindowsManually() const {return _removeWindowsAction->isChecked();}
  public slots:
    void updateAllFields();
  signals:
    void autoWindows();
    void beginAddWindowsManually();
    void endAddWindowsManually();
    void beginRemoveWindowsManually();
    void endRemoveWindowsManually();
    void inverseWindows();
    void clearWindows();
    void loadWindows();
  private slots:
    void setRawEnabled(bool b);
    void setFilteredEnabled(bool b);
    void toggleAddWindows();
    void toggleRemoveWindows();

    void on_isRaw_toggled( );
    void on_isFiltered_toggled( );
    void on_isRawTab_toggled( );
    void on_isFilteredTab_toggled( );
    void on_isTolerance_toggled( );
    void on_isGap_toggled( );
    void on_isOverlap_toggled( );
    void on_isBadSample_toggled( );
    void on_badSampleRelative_currentIndexChanged(int);
    void on_windowLengthType_currentIndexChanged(int);
    void on_isSeismicEventTrigger_toggled();
  signals:
    void parametersChanged();
  private:
    int _nComponents;
    QAction * _addWindowsAction, * _removeWindowsAction;
  };

} // namespace GeopsyGui

#endif // WINDOWINGPARAMETERWIDGET_H
