/***************************************************************************
**
**  This file is part of GeopsyGui.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2004-09-02
**  Copyright: 2004-2019
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef ABSTRACTTOOLWIDGET_H
#define ABSTRACTTOOLWIDGET_H

#include <GeopsyCore.h>
#include <QGpGuiTools.h>

#include "SubPoolWindow.h"
#include "GeopsyGuiDLLExport.h"

namespace GeopsyGui {

class SignalLayer;
class PickLayer;
class TimeWindowLayer;
class GeopsyGuiInterface;

class GEOPSYGUI_EXPORT AbstractToolWidget : public QWidget
{
  Q_OBJECT
public:
  AbstractToolWidget(QWidget * parent, int nChildren);
  ~AbstractToolWidget();

  bool setSubPool(SubPoolWindow * subPoolWin);
  virtual bool setSubPool(SubSignalPool * subPool);
  const SubSignalPool * subPool() const {return &_subPoolWindow->subPool();}
  void setLayers(SignalLayer * sl, PickLayer * pl, TimeWindowLayer * wl);

  virtual void closeChildren();
  virtual void restoreFields();
  virtual void beginSignalChange(Signal * ) {}
  virtual void endSignalChange(Signal * ) {}
  virtual void updateAllFields() {}
  virtual void start() {}
  virtual void waitFinished() {}

  void setLibSlot(GeopsyGuiInterface * lib, int slot) {_lib=lib; _libSlot=slot;}
  bool isLibSlot(GeopsyGuiInterface * lib, int slot) {return _lib==lib && _libSlot==slot;}

  SignalLayer * signalLayer() const {return _signalLayer;}
  TimeWindowLayer * timeWindowLayer() const {return _timeWindowLayer;}
  PickLayer * pickLayer() const {return _pickLayer;}
public slots:
  void windowActivated();
  bool loadLogParameters(QString fileName=QString());
  void saveLogParameters(QString fileName=QString());
  virtual void showTool();
signals:
  void updateSubPool();
protected:
  void closeEvent(QCloseEvent * e);
  // Kept during transition to new core tool structure
  virtual bool initStations(SubSignalPool * subPool) {Q_UNUSED(subPool) return true;}
  virtual AbstractParameters * parameters(AbstractParameters * param=0) const {return param;}
  virtual void setParameters(const AbstractParameters * param) {Q_UNUSED(param)}

  virtual void contextMenuEvent(QContextMenuEvent *e);

  bool subPoolLocked();
  void lockSubPool();
  void unlockSubPool();
protected:
  int _nChildren;
  QWidget ** _childrenList;
  AbstractTool * _tool;
private:
  SubPoolWindow * _subPoolWindow;
  SignalLayer * _signalLayer;
  TimeWindowLayer * _timeWindowLayer;
  PickLayer * _pickLayer;

  GeopsyGuiInterface * _lib;
  int _libSlot;
};

inline void AbstractToolWidget::setLayers(SignalLayer * sl, PickLayer * pl, TimeWindowLayer * wl)
{
  TRACE;
  _signalLayer=sl;
  _timeWindowLayer=wl;
  _pickLayer=pl;
}

} // namespace GeopsyGui

#endif // ABSTRACTTOOLWIDGET_H
