/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  GeopsyCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-02-21
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef STATIONPROCESSSIGNALS_H
#define STATIONPROCESSSIGNALS_H

#include "GeopsyCoreDLLExport.h"
#include "StationSignals.h"

namespace GeopsyCore {

class GEOPSYCORE_EXPORT StationProcessSignals
{
  TRANSLATIONS("StationProcessSignals")
public:
  StationProcessSignals(const StationSignals * originalSignals);
  StationProcessSignals(int nComponents);
  virtual ~StationProcessSignals();

  int nComponents() const {return _nComponents;}
  const StationSignals * originalSignals() const {return _originals;}

  void setHighPassFilter(double frequency);

  DoubleSignal * processed(int iComp) const {return _signals[iComp].processed;}
  DoubleSignal *& processed(int iComp) {return _signals[iComp].processed;}
  const double * processedSamples(int iComp) const {return _signals[iComp].processedSamples;}

  bool lockSamples();
  void unlockSamples();
protected:
  bool copyOriginalSignal(int iComp, const TimeRange& tw) {return copyOriginalSignal(iComp, tw, this);}
  bool copyOriginalSignal(int iComp, const TimeRange& tw, const StationProcessSignals * from);
private:
  int _nComponents;
  const StationSignals * _originals;
  class ComponentSignals
  {
  public:
    ComponentSignals() {processed=nullptr; merged=nullptr; filtered=nullptr; processedSamples=nullptr;}
    QList<DoubleSignal *> * merged;
    QList<DoubleSignal *> * filtered;
    DoubleSignal * processed;
    const double * processedSamples;
  };
  ComponentSignals * _signals;

  //bool setKeep(int iComp, const TimeRange& tw, const WindowingParameters& param, int stationIndex);
};

} // namespace GeopsyCore

#endif // STATIONPROCESSSIGNALS_H
