/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  GeopsyCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2016-01-25
**  Copyright: 2016-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef SEGDHEADER_H
#define SEGDHEADER_H

#include <QGpCoreTools.h>

#include "GeopsyCoreDLLExport.h"

namespace GeopsyCore {

#pragma pack(1)     /* set alignment to 1 byte boundary */

  class GEOPSYCORE_EXPORT SEGDHeader
  {
  public:
    SEGDHeader();

    bool read(QDataStream& s);
    bool write(QDataStream& s);
  private:
    union {
      struct {
        char raw0[64];
      } raw;
      struct {
        // General Header Block #1
        qint16 fileNumber;
        qint16 formatCode;
        qint8 generalConstants[6];
        qint8 year;
        qint8 additionalHeaderCount:4;
        qint16 day:12;
        qint8 hour;
        qint8 minute;
        qint8 second;
        qint8 manufacturerCode[3];
        qint8 bytesPerScan[3];
        qint8 baseScanInterval;
        qint8 polarity;
        qint8 exponent;
        qint8 recordType:4;
        qint16 recordLength:12;
        qint8 scanTypes;
        qint8 chanSets;
        qint8 skewBlocks;
        qint8 extendedHeaderBlk;
        qint8 externalHeaderBlk;

      } field;
    };
  };

#pragma pack()   // restore original alignment

} // namespace GeopsyCore

#endif // SEGDHEADER_H
