/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  GeopsyCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-10-20
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef MINISEEDREADER_H
#define MINISEEDREADER_H

#include <QGpCoreTools.h>

#include "MiniSeedRecords.h"

namespace GeopsyCore {

class MiniSeedRecords;

class MiniSeedReader
{
  TRANSLATIONS("MiniSeedReader")
public:
  MiniSeedReader(QString fileName, const MiniSeedRecords * records);
  ~MiniSeedReader();

  bool isValid() const {return _f;}
  enum Type {Text, Integer, Float, Double};
  void * nextRecord(Type& t, int& nSamples);
  bool atEnd() const;
  off_t lastPos() const;
private:
  const MiniSeedRecords * _records;
  QFile * _f;
  LibMSeed::MSRecord * _msr;
  int _sequenceIndex, _recordIndex;
};

} // namespace GeopsyCore

#endif // MINISEEDREADER_H
