/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  GeopsyCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-04-30
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef DYNAMICSIGNAL_H
#define DYNAMICSIGNAL_H

#include "GeoSignal.h"
#include "GeopsyCoreDLLExport.h"

namespace GeopsyCore {

class GEOPSYCORE_EXPORT DynamicSignal : public Signal
{
  TRANSLATIONS("DynamicSignal")
public:
  DynamicSignal(SignalDatabase * db) : Signal(db) {_maxNSamples=0; _startTimeShift=0;}
  ~DynamicSignal();

  void shiftStartTime(int nSamples);

  void set(const DateTime& t, const int * samples, int nSamples);
  void set(const DateTime& t, const double * samples, int nSamples);
  virtual qint64 dataSize() const {return _maxNSamples*static_cast<qint64>(sizeof(double));}
  virtual void setNSamples(int n);
private:
  virtual bool allocate() const;
  virtual void free() const;
  template <class sampleType> inline void set(const DateTime& t, const sampleType * samples, int nSamples);
private:
  int _maxNSamples;
  mutable int _startTimeShift;
};

} // namespace GeopsyCore

#endif // DYNAMICSIGNAL_H
