/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  GeopsyCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2010-03-20
**  Copyright: 2010-2019
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef CUSTOMFILEFORMATS_H
#define CUSTOMFILEFORMATS_H

#include <QGpCoreTools.h>

#include "GeopsyCoreDLLExport.h"
#include "SignalFileFormat.h"

namespace GeopsyCore {

class AbstractFileFormat;

class GEOPSYCORE_EXPORT CustomFileFormats : public XMLClass
{
public:
  CustomFileFormats();
  ~CustomFileFormats();

  virtual const QString& xml_tagName() const {return xmlCustomFileFormatsTag;}
  static const QString xmlCustomFileFormatsTag;

  void save();
  void restore();

  int count() const {return _formats.count();}
  QString name(int index) const;

  SignalFileFormat fromSuffix(const QString &suffix, const SignalFileFormat &stdfmt) const;
  SignalFileFormat fromContent(const QString& fileName) const;
  SignalFileFormat fromName(const QString& n) const;
  SignalFileFormat fromCaptionFilter(const QString& cf) const;
  QList<SignalFileFormat> list() const;
  bool contains(const QString& name) const;

  void clear(SignalFileFormat::Format id, bool userProperties);
  void add(AbstractFileFormat * format);
  void remove(int index);
  AbstractFileFormat * format(int index) {return _formats.at(index);}
  const AbstractFileFormat * format(int index) const {return _formats.at(index);}
protected:
  virtual void xml_writeChildren(XML_WRITECHILDREN_ARGS) const;
  virtual XMLMember xml_member(XML_MEMBER_ARGS);
private:
  QList<AbstractFileFormat *> _formats;
};

} // namespace GeopsyCore

#endif // CUSTOMFILEFORMATS_H
