/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  GeopsyCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-06-15
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef COMPLEXSIGNAL_H
#define COMPLEXSIGNAL_H

#include <QGpCoreTools.h>
#include "SignalTemplate.h"
#include "GeopsyCoreDLLExport.h"

namespace GeopsyCore {

class DoubleSignal;

class GEOPSYCORE_EXPORT ComplexSignal : public SignalTemplate<Complex>
{
public:
  ComplexSignal() : SignalTemplate<Complex>() {}
  ComplexSignal(int n) : SignalTemplate<Complex>(n) {}
  ComplexSignal(const ComplexSignal& o) : SignalTemplate<Complex>(o) {}

  bool square();
  bool sqrt();
  bool multiply(double d);
  Curve<Point2D> abs(double df) const;
  DoubleSignal * toDouble(DoubleSignal * sig=nullptr) const;
  void debugPrint() const;
};

} // namespace GeopsyCore

#endif // COMPLEXSIGNAL_H
