/***************************************************************************
**
**  This file is part of DinverDCCore.
**
**  DinverDCCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  DinverDCCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2009-07-27
**  Copyright: 2009-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "Target.h"

namespace DinverDCCore {

/*!
  \class Target Target.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Description of constructor still missing
*/
Target::Target()
    : XMLClass()
{
  TRACE;
  _selected=true;
  _misfitWeight=1.0;
  _minimumMisfit=0.0;
  _misfitType=L2_Normalized;
}

/*!
  Description of constructor still missing
*/
Target::Target(const Target& o)
    : XMLClass()
{
  TRACE;
  _selected=o._selected;
  _misfitWeight=o._misfitWeight;
  _minimumMisfit=o._minimumMisfit;
  _misfitType=o._misfitType;
}

void Target::xml_writeProperties(XML_WRITEPROPERTIES_ARGS) const
{
  TRACE;
  Q_UNUSED(context)
  writeProperty(s, "selected", _selected);
  writeProperty(s, "misfitWeight", _misfitWeight);
  writeProperty(s, "minimumMisfit", _minimumMisfit);
  writeProperty(s, "misfitType", RealStatisticalValue::misfitTypeString(_misfitType));
}

XMLMember Target::xml_member(XML_MEMBER_ARGS)
{
  TRACE;
  Q_UNUSED(context)
  Q_UNUSED(attributes)
  static const QString attName("type");
  if(tag=="misfitWeight" ) return XMLMember(0);
  else if(tag=="minimumMisfit" ) return XMLMember(1);
  else if(tag=="misfitType" ) return XMLMember(2);
  else if(tag=="selected" ) return XMLMember(3);
  else return XMLMember(XMLMember::Unknown);
}

bool Target::xml_setProperty(XML_SETPROPERTY_ARGS)
{
  TRACE;
  Q_UNUSED(tag)
  Q_UNUSED(attributes)
  Q_UNUSED(context)
  switch (memberID) {
  case 0: _misfitWeight=content.toDouble(); return true;
  case 1: _minimumMisfit=content.toDouble(); return true;
  case 2: _misfitType=RealStatisticalValue::misfitType(content.toString()); return true;
  case 3: _selected=content.toBool(); return true;
  default: return false;
  }
}

} // namespace DinverDCCore
