/***************************************************************************
**
**  This file is part of DinverCore.
**
**  DinverCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  DinverCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2005-11-05
**  Copyright: 2005-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <QGpCoreTools.h>
#include "DinverInterface.h"
#include "DinverCoreInstallPath.h"

namespace DinverCore {

/*!
  \class DinverInterface DinverInterface.h
  \brief Abstract interface for all Dinver inversion plugins


*/

/*!
  \fn QString DinverInterface::tag() const
  Unique tag to identify in .report files models generated by this plugin.
*/

/*!
  \fn QString DinverInterface::title() const
  User friendly title, displayed at Dinver startup.
*/

/*!
  \fn QString DinverInterface::version() const
  Current version of the plugin
*/

/*!
  TODO: rewrite for AbstractForward

  \fn InversionThread * DinverInterface::createNewThread(bool doInitialize, bool& ok)
  Main function to re-implement which creates inversion runs. The returned object must inherit InversionThread.
  Function InversionThread::misfit() is the most important to re-implement.

  If \a doInitialize is true, initialize the parameter space.

  The mandatory task here or before any call to misfit, is to define the parameters and the conditions that exist
  between them. This is achieve by calling

  \pre
  Param * x=addParam("x", "", -5.0, 5.0);
  Param * y=addParam("y", "", -5.0, 5.0);
  \pre

  The names and units allow a correct identification in log output by Dinver. Fixed parameters may be added to the
  parameter space (min=max). They are needed for checking condition in certain circumstances.
  On return, condition may be added between Param objects:

  \pre
  vs0->addCondition(ParamCondition::LessThan, 1.0, vs1, -2.0);  // means that vs0 is always less than 1.0*vs1-2.0
  \pre

  The first parameter is the type of condition:

  \li Param::LessThan
  \li Param::GreaterThan

  At the end it is necessary to call setVariableParam() to set the variable parameter list and to define the
  dimension of the problem.
*/

/*!
  Detailed description of the plugin
*/
QString DinverInterface::description() const
{
  TRACE;
  return tr("No description available");
}

/*!
  Create and return a widget that lets the user customize the target definition
*/
QWidget * DinverInterface::createTargetWidget()
{
  TRACE;
  return 0;
}

/*!
  Create and return a widget that lets the user customize the parameter space definition
*/
QWidget * DinverInterface::createParamWidget()
{
  TRACE;
  return 0;
}

/*!
  Place to add items to dinver file menu
*/
void DinverInterface::addFileMenu(QMenu * )
{
  TRACE;
}

/*!
  Place to add items to dinver view menu
*/
void DinverInterface::addViewMenu(QMenu * )
{
  TRACE;
}

/*!
  Function called after "File/New"
*/
void DinverInterface::clear ()
{
  TRACE;
}

/*!
  Re-implement this function to save parameters and targets (e.g. while saving dinver environments)
*/
void DinverInterface::xml_writeChildren(XML_WRITECHILDREN_ARGS) const
{
  TRACE;
  Q_UNUSED(s)
  Q_UNUSED(context)
}

/*!
  Re-implement this function to load parameters and targets (e.g. while restoring dinver environments)
*/
XMLMember DinverInterface::xml_member(XML_MEMBER_ARGS)
{
  TRACE;
  Q_UNUSED(tag)
  Q_UNUSED(attributes)
  Q_UNUSED(context)
  return XMLMember(XMLMember::Unknown);
}

/*!
  Re-implement this function to initialize parameters and targets (e.g. after restoring dinver environments)
*/
bool DinverInterface::xml_polishChild(XML_POLISHCHILD_ARGS)
{
  TRACE;
  Q_UNUSED(child)
  Q_UNUSED(context)
  return false;
}

/*!
  Check if the plugin version is compatible with the current core
*/
bool DinverInterface::isValid() const
{
  static const Version vRef(DINVERCORE_VERSION);
  Version v(interfaceVersion());
  return v.compatible(vRef);
}

/*!
  \fn const char * DinverInterface::interfaceVersion() const
  Returns the dinvercore version of the plugin (at compile time)
*/

} // namespace DinverCore
