/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2004-09-06
**  Copyright: 2004-2019
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef StationPair_H
#define StationPair_H

#include <GeopsyCore.h>

#include "ArraySelection.h"
#include "ArrayCoreDLLExport.h"

namespace ArrayCore {

  class ARRAYCORE_EXPORT StationPair
  {
  public:
    StationPair();
    StationPair(const StationPair& o);

    void setStations(const ArraySelection& array, int index1, int index2);
    void setStations(const NamedPoint& stat1, const NamedPoint& stat2);

    double distance() const {return _distance;}
    const Angle& azimuth() const {return _azimuth;}
    QString name() const {return _name;}
    int station1() const {return _s1;}
    int station2() const {return _s2;}
    NamedPoint coArray() const;

    static bool lessThan(const StationPair& p1, const StationPair& p2);
  private:
    int _s1, _s2;

    double _distance;
    Angle _azimuth;
    QString _name;
  };

} // namespace ArrayCore

#endif // STATIONPAIR_H
