/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2019-12-03
**  Copyright: 2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef FKTASKMANAGER_H
#define FKTASKMANAGER_H

#include "ArrayTaskManager.h"
#include "ArrayCoreDLLExport.h"
#include "FKCache.h"

namespace ArrayCore {

  class ARRAYCORE_EXPORT FKTaskManager : public ArrayTaskManager
  {
  public:
    FKTaskManager(const ArrayStations * array);
    ~FKTaskManager();

    virtual bool setParameters(const ArrayParameters * param);
    const FKParameters * parameters() const {return static_cast<const FKParameters *>(_parameters);}
  protected:
    LoopWorker * newWorker();

    FKCache * _gridCache;
  };

} // namespace ArrayCore

#endif // FKTASKMANAGER_H

