/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2018-11-09
**  Copyright: 2018-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "ActiveFKSteering.h"

namespace ArrayCore {

  /*!
    \class ActiveFKSteering ActiveFKSteering.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    Description of constructor still missing
  */
  ActiveFKSteering::ActiveFKSteering()
  {
    _count=0;
    _vectors=nullptr;
    _distances=nullptr;
    _amplitudeFactors=nullptr;
    _radialRotations=nullptr;
    _transverseRotations=nullptr;
  }

  /*!
    Description of destructor still missing
  */
  ActiveFKSteering::~ActiveFKSteering()
  {
    delete [] _vectors;
    delete [] _distances;
    delete [] _amplitudeFactors;
    delete [] _radialRotations;
    delete [] _transverseRotations;
  }

  void ActiveFKSteering::clear()
  {
    delete [] _vectors;
    delete [] _distances;
    delete [] _amplitudeFactors;
    delete [] _radialRotations;
    delete [] _transverseRotations;
    _count=0;
    _vectors=nullptr;
    _distances=nullptr;
    _amplitudeFactors=nullptr;
    _radialRotations=nullptr;
    _transverseRotations=nullptr;
  }

  void ActiveFKSteering::setSource(const Point& src, const ArraySelection& array)
  {
    clear();
    Point2D relSrc=array.array()->toRelative(src);
    _count=array.count();
    resize(_count);
    _vectors=new Point2D[_count];
    for(int i=0; i<_count; i++) {
      _vectors[i]=array.relativePos(i);
      _vectors[i]-=relSrc;
    }
  }

  void ActiveFKSteering::setDistances()
  {
    ASSERT(_vectors);
    _distances=new double[_count];
    for(int i=0; i<_count; i++) {
      _distances[i]=_vectors[i].length();
    }
  }

  void ActiveFKSteering::setAmplitudeFactors()
  {
    ASSERT(_distances);
    _amplitudeFactors=new double[_count];
    for(int i=0; i<_count; i++) {
      _amplitudeFactors[i]=1.0/std::sqrt(_distances[i]);
    }
  }

  void ActiveFKSteering::setRadialRotations()
  {
    _radialRotations=new Angle[_count];
    for(int i=0; i<_count; i++) {
      const Point2D& p=_vectors[i];
      _radialRotations[i]=Angle(p.x(), p.y());
    }
  }

  void ActiveFKSteering::setTransverseRotations()
  {
    _transverseRotations=new Angle[_count];
    for(int i=0; i<_count; i++) {
      const Point2D& p=_vectors[i];
      _transverseRotations[i]=Angle(-p.y(), p.x());
    }
  }

} // namespace ArrayCore

