/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2018-09-17
**  Copyright: 2018-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "ActiveConvFKVertical.h"
#include "ActiveFKSteeringOneComponent.h"
#include "FKGridSearch.h"
#include "FKCrossSpectrum.h"

namespace ArrayCore {

  /*!
    \class ActiveConvFKVertical ActiveConvFKVertical.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  ActiveConvFKVertical::ActiveConvFKVertical(FKCache * gridCache)
    : ConvFKVertical(gridCache)
  {
    delete _steering;
    _steering=new ActiveFKSteeringOneComponent;
    _steering->setArray(gridCache->array());
  }

  void ActiveConvFKVertical::setGrid(FKGridSearch * g, double step, double size)
  {
    g->setGrid(0.0, size, step);
  }

  /*!
    Source may vary from one cross spectrum to the next. Useless to cache a grid.
    Return always false to avoid initialization of the grid.
  */
  bool ActiveConvFKVertical::initGrid(int)
  {
    return false;
  }

  bool ActiveConvFKVertical::setSource(const QVector<int>& blocks)
  {
    bool ok=true;
    Point src=_crossSpectrum->setActiveSource(blocks, ok);
    if(!ok) {
      return false;
    }
    // When source grid is defined
    src+=_crossSpectrum->sourceOffset();
    ActiveFKSteeringOneComponent * steering=static_cast<ActiveFKSteeringOneComponent *>(_steering);
    steering->setSource(src, _crossSpectrum->array());
    steering->setDistances();
    steering->setAmplitudeFactors();
    return true;
  }

  void ActiveConvFKVertical::addCrossSpectrum()
  {
    // Correction for geometrical attenuation can also be achieved in steering
    // However, the steering correction is not the same for Conventional and High Resolution
    // Hence, simpler to correct the cross-spectrum.
    ActiveFKSteeringOneComponent * steering=static_cast<ActiveFKSteeringOneComponent *>(_steering);
    _crossSpectrum->addActiveVertical(*steering);
  }

  double ActiveConvFKVertical::value(const Point& k) const
  {
    if(isInsideLimits(k)) {
      ActiveFKSteeringOneComponent * s=static_cast<ActiveFKSteeringOneComponent *>(_steering);
      s->initValue(k.x());
      FKPower p(s);
      p.setConventionalValue(_crossSpectrum->rayleigh());
      return p.value();
    } else {
      return -1.0;
    }
  }

} // namespace ArrayCore

