/***************************************************************************
**
**  This file is part of waran.
**
**  waran is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  waran is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-07-08
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

// BEGIN AUTOINCLUDE SECTION
#include <GeopsyCore.h>
#include <GeopsyGui.h>
#include <QGpCoreTools.h>
#include <SciFigs.h>
#include "SignalViewer.h"
// END AUTOINCLUDE SECTION

/*!
  \class SignalViewer SignalViewer.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Description of constructor still missing
*/
SignalViewer::SignalViewer(QWidget * parent)
    : AxisWindow(parent)
{
  TRACE;
  _signalLayer=new SignalLayer(this);
  _signalLayer->setOffset(SignalLayer::VisibleOffset);
  _signalLayer->setClip(SignalLayer::NoClip);
  _signalLayer->setNormalize(SignalLayer::NormalizeVisibleAll);
  _signalLayer->setVariableArea(false);

  xAxis()->setTitle(tr("Time"));
  xAxis()->setScaleType(Scale::AbsoluteTime);

  yAxis()->setTitle("");
  yAxis()->setReversedScale(true);
  yAxis()->setZoomEnabled(false);
  xAxis()->setSizeInfo(15.0);
  yAxis()->setSizeInfo(10.0);
  yAxis()->setRange(0.0, 1.0);
}

/*!
  Description of destructor still missing
*/
SignalViewer::~SignalViewer()
{
  TRACE;
}

void SignalViewer::lock()
{
  _signalLayer->lockDelayPainting();
}

void SignalViewer::unlock()
{
  _signalLayer->unlock();
}

void SignalViewer::setSignals(SubSignalPool * subPool)
{
  TRACE;
  _signalLayer->subPoolUpdate(subPool);
  // Adjust Y axis
  double ymin=0, ymax=1;
  _signalLayer->minMaxY(ymin, ymax);
  Axis& a=*yAxis();
  a.setRange(ymin, ymax);
  switch(subPool->count()) {
  case 0:
    break;
  case 1:
    a.setTitle(subPool->first()->effectiveAmplitudeUnit());
    a.setNumberType('e');
    a.setAutoTicks(true);
    a.setScaleType(Scale::Linear);
    a.removeStringLabels();
    a.setReversedScale(false);
    break;
  default:
    a.setReversedScale(true);
    a.setTitle( "" );
    a.setAutoTicks(false);
    a.setMajorTicks(1.0);
    a.setMinorTicks(1.0);
    a.setScaleType(Scale::Linear);
    a.removeStringLabels();
    int n=subPool->count() - 1;
    for(int i=0; i<n; i++ ) {
      a.addStringLabel(subPool->at(i)->nameComponent(), false);
    }
    // Update axis... while adding the last label
    a.addStringLabel(subPool->at(n)->nameComponent(), true);
  }
  update();
}

void SignalViewer::setDisplayRange(double l)
{
  double maxTime=xAxis()->maximum();
  xAxis()->setRange(maxTime-l, maxTime);
  deepUpdate();
}

void SignalViewer::setMaximumTime(const DateTime& t)
{
  // Adjust X axis
  double requestedMaxTime=xAxis()->timeReference().secondsTo(t);
  double maxTime=xAxis()->maximum();
  double deltaTime=maxTime-xAxis()->minimum();
  if(requestedMaxTime>maxTime) {
    maxTime=requestedMaxTime;
    xAxis()->setRange(maxTime-deltaTime, maxTime);
  }
  deepUpdate();
}
