/***************************************************************************
**
**  This file is part of waran.
**
**  waran is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  waran is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2011-08-18
**  Copyright: 2011-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "NetworkParameters.h"

/*!
  \class NetworkParameters NetworkParameters.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

NetworkParameters::NetworkParameters()
  : AbstractParameters()
{
#ifndef Q_OS_WIN
  _unitList="/etc/hosts";
#else
  _unitList="stations";
#endif
  _acquisitionUnitPrefix="WAU";
  _repeaterUnitPrefix="WRU";
  _processingUnitName="WPU01";
}

NetworkParameters::NetworkParameters(const NetworkParameters& o)
  : AbstractParameters(o),
    _unitList(o._unitList),
    _acquisitionUnitPrefix(o._acquisitionUnitPrefix),
    _repeaterUnitPrefix(o._repeaterUnitPrefix),
    _processingUnitName(o._processingUnitName)
{
}

void NetworkParameters::save()
{
  TRACE;
  QSettings& reg=CoreApplication::instance()->settings();
  reg.beginGroup("NetworkParameters");
  reg.setValue("unitList", _unitList);
  reg.setValue("acquisitionUnitPrefix", _acquisitionUnitPrefix);
  reg.setValue("processingUnit", _processingUnitName);
}

void NetworkParameters::restore()
{
  TRACE;
  QSettings& reg=CoreApplication::instance()->settings();
  reg.beginGroup("NetworkParameters");
  _unitList=reg.value("unitList", _unitList).toString();
  _acquisitionUnitPrefix=reg.value("acquisitionUnitPrefix", _acquisitionUnitPrefix).toString();
  _processingUnitName=reg.value("processingUnit", _processingUnitName).toString();
}
