/***************************************************************************
**
**  This file is part of waran.
**
**  waran is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  waran is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2012-02-08
**  Copyright: 2012-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "NetLink.h"
#include "Station.h"


/*!
  \class NetLink NetLink.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Description of constructor still missing
*/
NetLink::NetLink(Station * station)
  : DaemonLink(station)
{
  TRACE;
  setPort(2979);
}

/*!

*/
int NetLink::bytesAvailable(const char * buffer, int bytesCount)
{
  TRACE;
  int bytesRead=0;
  while(bytesRead<bytesCount) {
    // Scan for a line
    int newBytesRead;
    for(newBytesRead=bytesRead; newBytesRead<bytesCount && buffer[newBytesRead]!='\n'; newBytesRead++) {}
    if(newBytesRead==bytesCount) {
      return bytesRead; // partial line
    }
    station()->setBuddies(QString::fromLatin1(buffer+bytesRead, newBytesRead-bytesRead));
    bytesRead=newBytesRead+1;
    // Skip blanks and additionnal end of line characters
    while(bytesRead<bytesCount && isspace(buffer[bytesRead])) {bytesRead++;}
  }
  return bytesRead;
}
