/***************************************************************************
**
**  This file is part of waran.
**
**  waran is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  waran is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2012-12-12
**  Copyright: 2012-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include <QGpGuiTools.h>

#include "CommentsWidget.h"
#include "Station.h"

/*!
  \class CommentsWidget CommentsWidget.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Description of constructor still missing
*/
CommentsWidget::CommentsWidget(QWidget * parent)
  : QWidget(parent)
{
  TRACE;
  setupUi(this);

  operatorName->addItems(Settings::getHistory("OperatorNames"));
}

/*!
  Description of destructor still missing
*/
CommentsWidget::~CommentsWidget()
{
  TRACE;
}

void CommentsWidget::setStations(QList<Station *> * list)
{
  TRACE;
  _stations=list;
  stationList->clear();
  for(QList<Station *>::iterator it=_stations->begin(); it!=_stations->end(); it++) {
    stationList->addItem((*it)->name());
    disconnect(*it, SIGNAL(dataChanged(int)), this, SLOT(stationChanged(int)));
    connect(*it, SIGNAL(dataChanged(int)), this, SLOT(stationChanged(int)));
    disconnect(*it, SIGNAL(commentsRefreshed(int)), this, SLOT(commentsChanged(int)));
    connect(*it, SIGNAL(commentsRefreshed(int)), this, SLOT(commentsChanged(int)));
  }
  on_stationList_currentIndexChanged();
}

void CommentsWidget::stationChanged(int stationIndex)
{
  TRACE;
  if(stationIndex==stationList->currentIndex()) {
    Station * s=_stations->at(stationIndex);
    if(s->isAvailable() && !addCurrent->isEnabled()) {
      addCurrent->setEnabled(true);
      s->requestComments();
    }
  }
}

void CommentsWidget::commentsChanged(int stationIndex)
{
  TRACE;
  if(stationIndex==stationList->currentIndex()) {
    Station * s=_stations->at(stationIndex);
    comments->setPlainText(s->comments());
    statusMessage->setText(tr("Online comments"));
  }
}

void CommentsWidget::on_stationList_currentIndexChanged(int)
{
  TRACE;
  int index=stationList->currentIndex();
  Station * s=_stations->at(index);
  if(s->isAvailable()) {
    s->requestComments();
    statusMessage->setText(tr("Downloading comments for station %1...").arg(s->name()));
    addCurrent->setEnabled(true);
  } else {
    statusMessage->setText(tr("Offline comments"));
    addCurrent->setEnabled(false);
  }
  // Displays offline comments
  comments->setPlainText(s->comments());
  addCurrent->setText(tr("Add to %1").arg(s->name()));
}

void CommentsWidget::on_addCurrent_clicked()
{
  TRACE;
  Station * s=_stations->at(stationList->currentIndex());
  statusMessage->setText(tr("Add comment to station %1...").arg(s->name()));
  s->addComment(decoratedNewComment());
  on_stationList_currentIndexChanged();
}

void CommentsWidget::on_addAll_clicked()
{
  TRACE;
  statusMessage->setText(tr("Add comment to all stations..."));
  QString c=decoratedNewComment();
  for(QList<Station *>::iterator it=_stations->begin(); it!=_stations->end(); it++) {
    (*it)->addComment(c);
  }
  on_stationList_currentIndexChanged();
}

QString CommentsWidget::decoratedNewComment() const
{
  Settings::setHistory("OperatorNames", operatorName->currentText());
  QString c;
  c+="---------- ";
  c+=QDateTime::currentDateTime().toString("yyyy-MM-dd hh:mm:ss");
  c+=" by ";
  c+=operatorName->currentText();
  c+=" at ";
  c+=location->text();
  c+="\n\n";
  c+=newComments->toPlainText();
  if(c.right(1)!="\n") {
    c+="\n";
  }
  c+="\n";
  return c;
}
