/***************************************************************************
**
**  This file is part of max2curve.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2006-01-13
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef FKHISTOGRAMWIDGET_H
#define FKHISTOGRAMWIDGET_H

#include <QGpCoreTools.h>
#include <QGpCoreWave.h>
#include <QGpGuiMath.h>

#include "ui_HistogramWidget.h"
#include "StatGridAnalyser.h"
#include "MaxEntryList.h"

class HistogramWidget : public QWidget, public Ui::HistogramWidget
{
  Q_OBJECT
public:
  HistogramWidget(MaxEntryList * maxList, QWidget * parent=nullptr);
  ~HistogramWidget();

  bool loadMax(QString fileName);
  bool select(bool scaleTypeForced, SamplingOption scaleType);
  void initGrid(int nValueClasses, double minValueHisto, double maxValueHisto, SamplingOption ySampling);
  void fillGrid();
  MaxEntryList * maxEntryList() {return _maxList;}
  void toStream(QTextStream& s, int curveIndex);

  void loadCurves(const QString& fileName, const QString& parserFileName=QString());
  void gridFilterThreshold(double t);
  void gridFilterWavenumber(double kmin, double kmax);
  void gridFilterCurve(int curveIndex, double sigmaFactor);

  void exportPlot(const ExportOptions& o);
public slots:
  void show();
  void addMeanCurve();
  void addMedianCurve();
  void addModeCurve();
private slots:
  void on_gridFilter_clicked();
  void on_gridSmooth_clicked();
  void on_closeButton_clicked();
  void on_saveButton_clicked();
  void unselectValue(double frequency, double minValue, double maxValue);
  void selectAll(double frequency);
  void adjustCurve();
protected:
  virtual void closeEvent(QCloseEvent *e);
private:
  void setGrid(IrregularGrid2D& grid);
  AxisWindow * graph();
  bool isLogScale();
  void addCurve(const Curve<RealStatisticalPoint>& c);
  void setLimits();
  void normalizeGrid(IrregularGrid2D& grid);

  MaxEntryList * _maxList;
  StatGridAnalyser * _statWidget;
  IrregularGrid2DPlot * _gridLayer;
  CurveBrowser * _curves;
};

#endif // FKHISTOGRAMWIDGET_H
