/***************************************************************************
**
**  This file is part of gpviewmax.
**
**  gpviewmax is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gpviewmax is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2018-07-19
**  Copyright: 2018-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef SAMPLES_H
#define SAMPLES_H

#include <QGpCoreMath.h>
#include <QGpCoreWave.h>

#include "Sample.h"

class Samples : public QVector<Sample>
{
public:
  Samples * filterNullEllipticities() const;
  Samples * filterNoise(double threshold) const;
  Samples * filterRelativePower(double threshold);
  Samples * filterCurve(const ModalCurve& curve, double relativeRange) const;
  Samples * filterNoiseSmart(double noiseDev, double slowDev);

  QVector<Histogram2D::Sample> dispersionSamples() const;
  QVector<Histogram2D::Sample> ellipticitySamples() const;
  QVector<Histogram2D::Sample> noiseSamples() const;
  QVector<Histogram2D::Sample> azimuthSamples() const;
  QVector<Histogram2D::Sample> powerSamples() const;

  bool save(const QString& fileName, const QString& headerLine, const QString& polarization) const;
private:
  static bool lessThan(const Sample& s1, const Sample& s2);
  static bool lessThanSlowness(const Sample& s1, const Sample& s2);
  void selectPower(Samples& samples, int beginIndex, int endIndex, double minPower) const;
};

#endif // SAMPLES_H

