/***************************************************************************
**
**  This file is part of gprefra.
**
**  gprefra is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gprefra is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-12-15
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <QGpCoreTools.h>
#include <QGpCoreWave.h>
#include "RefraReader.h"

/*!
  \class RefraReader RefraReader.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Description of constructor still missing
*/
RefraReader::RefraReader()
    : ArgumentStdinReader()
{
  TRACE;
  _mode=TravelTimes;
}

bool RefraReader::setOptions(int& argc, char ** argv)
{
  TRACE;
  // Check arguments
  int i, j=1;
  for(i=1; i<argc; i++) {
    QByteArray arg=argv[i];
    if(arg[0]=='-') {
      if(arg=="-src") {
        CoreApplication::checkOptionArg(i, argc, argv);
        QStringList l=QString(argv[i]).split(",");
        for(QStringList::iterator it=l.begin();it!=l.end();it++) {
          _sources.append(it->toDouble());
        }
      } else if(arg=="-rec") {
        CoreApplication::checkOptionArg(i, argc, argv);
        QStringList l=QString(argv[i]).split(",");
        for(QStringList::iterator it=l.begin();it!=l.end();it++) {
          _receivers.append(it->toDouble());
        }
      } else if(arg=="-travel-times") {
        _mode=TravelTimes;
      } else if(arg=="-ray-paths") {
        _mode=RayPaths;
      } else {
        App::log(tr("gprefra: bad option %1, see -help\n").arg(argv[i]) );
        return false;
      }
    } else {
      argv[j++]=argv[i];
    }
  }
  if(j < argc) {
    argv[j]=nullptr;
    argc=j;
  }
  // Sort sources and receivers
  std::sort(_sources.begin(), _sources.end());
  std::sort(_receivers.begin(), _receivers.end());
  return true;
}

bool RefraReader::parse(QTextStream& s)
{
  TRACE;
  QTextStream sOut(stdout);
  RefractionDippingModel m;
  QString comments;
  if(!m.fromStream(s, &comments)) {
    return false;
  }
  if(m.layerCount()>0) {
    m.begin();
    TiltNode srcNode, recNode;
    int deepestLayer;
    for(QVector<double>::const_iterator itSrc=_sources.begin(); itSrc!=_sources.end(); itSrc++) {
      srcNode.init(*itSrc,m);
      sOut << QString("# Source at %1\n").arg(*itSrc);
      switch(_mode) {
      case TravelTimes:
        sOut << "# Receiver(m) Time(s)\n";
        break;
      case RayPaths:
        break;
      }
      for(QVector<double>::const_iterator itRec=_receivers.begin(); itRec!=_receivers.end(); itRec++) {
        recNode.init(*itRec,m);
        switch(_mode) {
        case TravelTimes:
          sOut << QString("%1 %2\n").arg(*itRec).arg(m.travelTime(srcNode, recNode, deepestLayer));
          break;
        case RayPaths:
          sOut << QString("# Receiver at %1\n").arg(*itRec)
               << m.ray(srcNode, recNode).toString();
          break;
        }
      }
    }
    m.end();
  }
  return true;
}
