/***************************************************************************
**
**  This file is part of gpmaplayer.
**
**  gpmaplayer is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gpmaplayer is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2016-03-25
**  Copyright: 2016-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef IMAGESOURCE_H
#define IMAGESOURCE_H

#include <QGpCoreMath.h>
#include <QGpGuiTools.h>

class ColumnImageMerger;

class ImageSource : public QObject
{
  Q_OBJECT
public:
  ImageSource(QObject * parent=nullptr);
  ~ImageSource();

  bool isAvailable() const {return _access && _access->isReady();}

  void setUtmZone(const UtmZone& z) {_utmZone=z;}
  const UtmZone utmZone() const {return _utmZone;}

  void setRect(Rect r);
  const Rect& rect() const {return _rect;}

  const Point2D& step() const {return _step;}

  void setOutputBaseName(const QString& n) {_outputBaseName=n;}
  const QString& outputBaseName() const {return _outputBaseName;}

  void setZoom(int z);
  int zoom() const {return _zoom;}

  static Rect rect(const Point2D& loc, double radius);
signals:
  void imageReady(const QImage& im);
private slots:
  void setStep();
  void start();
  void imageDownloaded(bool);
  void processImage(const QImage& im);
private:
  QString imageFileName(const Point2D& c);
  void mergeColumns(const QImage& im);
  void mergeRows();
  void request(const Point2D& center);
  void setStepMaster(const QImage& im);
  void setStepSlaveX(const QImage& im);
  void setStepSlaveY(const QImage& im);
  void computeStep();

  int _zoom;
  double _pixelShift;
  Rect _rect;
  Point2D _step;
  QString _outputBaseName;
  UtmZone _utmZone;

  HttpAccess * _access;
  QVector<ColumnImageMerger *> _columns;
  int _currentIndex;
  enum Mode {SetStepMaster, SetStepSlaveX, SetStepSlaveY, MergeColumns};
  Mode _mode;
};

#endif // IMAGESOURCE_H
