/***************************************************************************
**
**  This file is part of gplivemodel.
**
**  gplivemodel is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gplivemodel is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-10-16
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "ResultsThread.h"

/*!
  \class ResultsThread ResultsThread.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Description of constructor still missing
*/
ResultsThread::ResultsThread(QObject * parent)
    : Thread(parent)
{
  TRACE;
  _terminated=false;
  _automaticLimits=true;
}

/*!
  Description of destructor still missing
*/
ResultsThread::~ResultsThread()
{
  TRACE;
}

/*!
  Creates a legend and returns it
*/
LegendWidget * ResultsThread::createLegend(GraphicSheet * sheet, double x, double y, const QString& t)
{
  TRACE;
  LegendWidget * leg=new LegendWidget;
  leg->setPrintXAnchor(x);
  leg->setPrintYAnchor(y);
  leg->setTitle(t);
  leg->update();
  sheet->addObject(leg);
  sheet->showObject(leg);
  return leg;
}

void ResultsThread::start(QList<GeophysicalModel *> models)
{
  TRACE;
  _models=models;
  _terminated=false;
  Thread::start();
}

void ResultsThread::run()
{
  TRACE;
  QList<GeophysicalModel *>::iterator it;
  for(it=_models.begin(); it!=_models.end(); it++) {
    if(terminated()) break;
    run( *it);
  }
  qDeleteAll(_models);
}

void ResultsThread::setAutomaticLimits(bool a)
{
  TRACE;
  _automaticLimits=a;
  if(_automaticLimits) {
    setModelLimits();
    setResultsLimits();
  }
}
