/***************************************************************************
**
**  This file is part of gplivemodel.
**
**  gplivemodel is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gplivemodel is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-12-15
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <QGpCoreWave.h>
#include <QGpGuiTools.h>
#include "LiveModelReader.h"
#include "MainWindow.h"

/*!
  \class LiveModelReader LiveModelReader.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Description of constructor still missing
*/
LiveModelReader::LiveModelReader()
    : ArgumentStdinReader()
{
  TRACE;
  _curveType=Results::Dispersion;
  _readStdin=false;
  _scanCount=10;
  _w=0;
}

LiveModelReader::~LiveModelReader()
{
  TRACE;
  delete _w;
}

bool LiveModelReader::setOptions(int& argc, char ** argv)
{
  TRACE;
  // Curve type
  int i, j=1;
  for(i=1; i<argc; i++) {
    QByteArray arg=argv[i];
    if(arg[0]=='-') {
      if(arg=="-disp") {
        _curveType=Results::Dispersion;
      } else if(arg=="-disp-grid") {
        _curveType=Results::DispersionGrid;
      } else if(arg=="-ell") {
        _curveType=Results::Ellipticity;
      } else if(arg=="-sh") {
        _curveType=Results::ShAmplification;
      } else if(arg=="-mt") {
        _curveType=Results::MagnetoTelluric;
      } else {
        argv[j++]=argv[i];
      }
    } else {
      argv[j++]=argv[i];
    }
  }
  if(j < argc) {
    argv[j]=nullptr;
    argc=j;
  }
  _w=new MainWindow;
  if( ! _w->results()->setCurveType(_curveType, argc, argv)) {
    return false;
  }

  // Check other arguments
  j=1;
  for(i=1; i<argc; i++) {
    QByteArray arg=argv[i];
    if(arg[0]=='-') {
      if(arg=="-stdin") {
        _readStdin=true;
      } else if(arg=="-panel") {
        Application::checkOptionArg(i, argc, argv);
        _panelFile=argv[i];
      } else if(arg=="-scan") {
        Application::checkOptionArg(i, argc, argv);
        _sliderName=argv[i];
        _readStdin=true;
      } else if(arg=="-scan-count") {
        Application::checkOptionArg(i, argc, argv);
        _scanCount=atoi(argv[i]);
      } else {
        App::log(tr("gplivemodel: bad option %1, see -help\n").arg(argv[i]) );
        return false;
      }
    } else {
      argv[j++]=argv[i];
    }
  }
  if(j < argc) {
    argv[j]=nullptr;
    argc=j;
  }
  if(!_sliderName.isEmpty()) {
    if(_panelFile.isEmpty()) {
      App::log(tr("gplivemodel: option 'panel' is required with option 'scan'.\n").arg(argv[i]) );
      return false;
    }
  }
  if( !_panelFile.isEmpty()) {
    _w->loadPanel(_panelFile);
  }
  if(_readStdin || argc>1) read(argc, argv);
  return true;
}

bool LiveModelReader::parse(QTextStream& s)
{
  TRACE;
  QTextStream sOut(stdout);
  Seismic1DModel m;
  QString comments;
  if(!m.fromStream(s, &comments)) {
    return false;
  }
  if(m.layerCount()>0) {
    if(!_sliderName.isEmpty()) {
      _w->scan(&m, _sliderName, _scanCount);
    } else {
      _w->addBackground(&m, comments);
    }
  }
  return true;
}

int LiveModelReader::exec()
{
  TRACE;
  Settings::getRect(_w, "MainWindow" );
  _w->show();
  _w->setBackground();
  int appReturn=qApp->exec();
  Settings::setRect(_w, "MainWindow" );
  return appReturn;
}
