/***************************************************************************
**
**  This file is part of gphistogram.
**
**  gphistogram is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gphistogram is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-12-18
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef HISTOGRAMWIDGET_H
#define HISTOGRAMWIDGET_H

#include <QGpGuiMath.h>
#include <QGpCoreStat.h>

#include "ui_HistogramWidget.h"
#include "GaussianMixtureOutput.h"

class HistogramWidget : public QWidget, private Ui::HistogramWidget
{
  Q_OBJECT
public:
  HistogramWidget(QWidget * parent=nullptr);
  ~HistogramWidget();

  void setNormalize(bool n) {_normalize=n;}
  void setHistogram(Histogram2D * hist);
  void setHistogramComments(QString cmt);
  void exportPlot(const ExportOptions& o);
  void setGaussianMixtureParameters(const GaussianMixtureParameters& p);
  void setHeaderLine(const QString& h) {_headerLine=h;}
  bool loadCurves(const QStringList& fileNames, const QString& formatFileName);
private slots:
  void on_xScroll_valueChanged();
  void setBand(double min, double max);
  void nextX() {shortcutEvents(NextX);}
  void nextXReject() {shortcutEvents(NextXReject);}
  void previousX() {shortcutEvents(PreviousX);}
  void previousXReject() {shortcutEvents(PreviousXReject);}
  void increaseLowLimit() {shortcutEvents(IncreaseLowLimit);}
  void increaseHighLimit() {shortcutEvents(IncreaseHighLimit);}
  void decreaseLowLimit() {shortcutEvents(DecreaseLowLimit);}
  void decreaseHighLimit() {shortcutEvents(DecreaseHighLimit);}
  void on_saveBut_clicked();
  void on_rejectBut_clicked();
  void on_undoBut_clicked();
  void on_rejectAllBut_clicked();
  void on_undoAllBut_clicked();
  void on_gridFilter_clicked();
  void adjustCurve();
  void addMeanCurve();
  void addMedianCurve();
  void addModeCurve();
  void addGaussianMixturePoint();
  void addGaussianMixtureCurve();
  void addGaussianMixture(int index);
protected:
  void closeEvent(QCloseEvent * e);
private:
  enum Shortcuts {NextX, NextXReject,
                   PreviousX, PreviousXReject,
                   IncreaseLowLimit, IncreaseHighLimit,
                   DecreaseLowLimit, DecreaseHighLimit};
  void shortcutEvents(Shortcuts s);
  void saveBand(int ix, double min, double max);
  Point2D restoreBand(int ix);
  void addCurve(const Curve<RealStatisticalPoint>& c);
  void setLimits();

  bool _normalize;
  QString _xUnit, _yUnit;

  Histogram2D * _hist;
  IrregularGrid2DPlot * _histogramLayer;

  ParallelBands * _densityBandLayer;
  LineLayer * _densityCurveLayer;
  ParallelBands * _cumulativeBandLayer;
  LineLayer * _cumulativeCurveLayer;
  int _lastX;

  QString _headerLine;
  CurveProperties * _gaussianMixtureCurve;
  HistogramDensities _gaussianMixtureDensities;
  GaussianMixtureOutput _gaussianMixtureOutput;

};

#endif // HISTOGRAMWIDGET_H
