/***************************************************************************
**
**  This file is part of gpgridsearch.
**
**  gpgridsearch is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gpgridsearch is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2016-04-25
**  Copyright: 2016-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef READER_H
#define READER_H

#include <DinverDCCore.h>

class Reader : public ArgumentStdinReader
{
public:
  Reader();
  ~Reader();

  bool setOptions(int& argc, char ** argv);
  void run();

  const ParamGroundModel& groundModel() const {return _groundModel;}
  const RealSpace& parameterSpace() const {return _paramSpace;}
  const Curve<Point1D> * values() const {return _values;}
  const TargetList& targets() const {return _targets;}
  ReportWriter * beginWriteReport() const;
  void endWriteReport() const;
protected:
  virtual bool parse(QTextStream& s);
private:
  double forwardCount() const;

  ParamGroundModel _groundModel;
  RealSpace _paramSpace;
  Curve<Point1D> * _values;
  int _paramIndex;
  TargetList _targets;
  mutable Mutex _reportMutex;
  mutable ReportWriter * _outputReport;
};

#endif // READER_H
