/***************************************************************************
**
**  This file is part of geopsytfa.
**
**  geopsytfa is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  geopsytfa is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-07-13
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef TFAPARAMETERS_H
#define TFAPARAMETERS_H

#include <GeopsyCore.h>

class ToolTFAd;

class TFAParameters : public AbstractParameters
{
public:
  TFAParameters();
  TFAParameters(const TFAParameters& o);

  virtual AbstractParameters * clone() const;

  TimeRangeParameters& range() {return _range;}
  const TimeRangeParameters& range() const {return _range;}
  void setRange(const TimeRangeParameters& r) {_range=r;}

  SamplingParameters& frequencySampling() {return _frequencySampling;}
  const SamplingParameters& frequencySampling() const {return _frequencySampling;}
  void setFrequencySampling(const SamplingParameters& f) {_frequencySampling=f;}

  MorletParameters& wavelet() {return _wavelet;}
  const MorletParameters& wavelet() const {return _wavelet;}
  void setWavelet(const MorletParameters& w) {_wavelet=w;}

  virtual QString toString(PARAMETERS_TOSTRING_ARGS_DECL) const;
  virtual void collectKeywords(PARAMETERS_COLLECTKEYWORDS_ARGS);
protected:
  virtual void setVersion(PARAMETERS_SETVERSION_ARGS);
private:
  TimeRangeParameters _range;
  SamplingParameters _frequencySampling;
  MorletParameters _wavelet;
};

#endif // TFAPARAMETERS_H

