/***************************************************************************
**
**  This file is part of geopsynr.
**
**  geopsynr is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  geopsynr is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-08-06
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "NRPlugin.h"
#include "ToolNR.h"

#include "geopsynrInstallPath.h"
#include "geopsynrVersion.h"
#include "GeopsyCoreVersion.h"

/*!
  \class NRPlugin NRPlugin.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

const char * NRPlugin::interfaceVersion() const
{
  return GEOPSYCORE_VERSION;
}

void NRPlugin::createToolActions(QObject * toolFactory)
{
  TRACE;
  QAction * a;

  a=new QAction(toolFactory);
  a->setText(tr("Noise reduction"));
  a->setIcon(QIcon(":nr-22x22.png"));
  connect(a, SIGNAL(triggered()), toolFactory, SLOT(showTool()) );
  addAction(a);
}

AbstractToolWidget * NRPlugin::createTool(int id, QWidget * wsParent) const
{
  TRACE;
  switch (id) {
  case 0:
    return new ToolNR(wsParent);
  default:
    return 0;
  }
}

PACKAGE_INFO("geopsynr", GEOPSYNR)
#if(QT_VERSION < QT_VERSION_CHECK(5, 0, 0))
Q_EXPORT_PLUGIN2(geopsynr, NRPlugin)
#endif
