/***************************************************************************
**
**  This file is part of geopsy.
**
**  geopsy is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  geopsy is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2010-08-06
**  Copyright: 2010-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef ENGINE_H
#define ENGINE_H

#include <GeopsyGui.h>

#include "WindowEnvironment.h"
#include "MainWindow.h"

class ToolFactory;

class Engine: public QObject, public GeopsyGuiEngine
{
  Q_OBJECT
public:
  Engine();
  ~Engine();

  static Engine * instance() {return static_cast<Engine *>(GeopsyCoreEngine::instance());}

  virtual SignalDatabase * database(QWidget * w);

  virtual void newSignalViewer(const SubSignalPool& subPool=SubSignalPool());
  virtual QWidgetList subWindowList(QWidget * parent=nullptr) const;

  virtual void beginAddFile(SignalDatabase * db);
  virtual void endAddFile(SignalDatabase * db);

  virtual void beginSignalChange(Signal * sig);
  virtual void endSignalChange(Signal * sig);

  virtual void beginSignalChange(SignalDatabase * db);
  virtual void endSignalChange(SignalDatabase * db);

  virtual inline MultiDocumentSubWindow * addSubWindow(QWidget * parent, QWidget * w);
  virtual inline void removeSubWindow(QWidget * w);

  virtual bool useProgress() {return true;}
  virtual void setProgressMaximum(SignalDatabase * db, int value);
  virtual int progressMaximum(SignalDatabase * db);
  virtual void setProgressValue(SignalDatabase * db, int value);
  virtual int progressValue(SignalDatabase * db);
  virtual void increaseProgressValue(SignalDatabase * db, int value=1);
  virtual void showMessage(SignalDatabase * db, QString message);
public slots:
  virtual SubPoolWindow * newTableWindow(QWidget * parent=nullptr, const SubSignalPool& subPool=SubSignalPool());
  virtual AbstractGraphicWindow * newGraphicWindow(QWidget * parent=nullptr, const SubSignalPool& subPool=SubSignalPool());
  virtual SubPoolWindow * newMapWindow(QWidget * parent=nullptr, const SubSignalPool& subPool=SubSignalPool());
  virtual SubPoolWindow * newChronogramWindow(QWidget * parent=nullptr, const SubSignalPool& subPool=SubSignalPool());
};

inline MultiDocumentSubWindow * Engine::addSubWindow(QWidget * parent, QWidget * w)
{
  return WindowEnvironment::instance()->addSubWindow(parent, w);
}

inline void Engine::removeSubWindow(QWidget * w)
{
  WindowEnvironment::instance()->removeSubWindow(w);
}

#endif // ENGINE_H
