/***************************************************************************
**
**  This file is part of dinverext.
**
**  dinverext is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  dinverext is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-04-11
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef EXTTARGET_H
#define EXTTARGET_H

#include <QGpCoreTools.h>

class ExtTarget : public XMLClass
{
  TRANSLATIONS("ExtTarget")
public:
  ExtTarget() {}
  ExtTarget(const ExtTarget& o);

  virtual const QString& xml_tagName() const {return xmlExtTargetTag;}
  static const QString xmlExtTargetTag;

  bool isOk(int nParams);

  void setCommand(QString c) {_command=c;}
  QString command() const {return _command;}

  void setWorkingDirectory(QString wd) {_workingDirectory=wd;}
  QString workingDirectory() const {return _workingDirectory;}
protected:
  virtual void xml_writeProperties(XML_WRITEPROPERTIES_ARGS) const;
  virtual XMLMember xml_member(XML_MEMBER_ARGS);
  virtual bool xml_setProperty(XML_SETPROPERTY_ARGS);
private:
  QString _command, _workingDirectory;
};

#endif // EXTTARGET_H
