/***************************************************************************
**
**  This file is part of dinverdc.
**
**  dinverdc is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  dinverdc is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2005-10-27
**  Copyright: 2005-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef AUTOCORRTARGETWIDGET_H
#define AUTOCORRTARGETWIDGET_H

#include <QGpGuiWave.h>

class RingBrowser;

class AutocorrTargetWidget : public ModalCurveBrowser, public WidgetRect
{
  Q_OBJECT
public:
  AutocorrTargetWidget(QWidget * parent=nullptr);
  ~AutocorrTargetWidget();

  virtual void load();
  virtual void clear();
  virtual void setEditable(bool e);

  int count();
  void setLimits();
  AutocorrCurves curves();
  void addCurves(const AutocorrCurves& newCurves);
  ModalCurve& addCurve(int index);
protected:
  void resizeEvent(QResizeEvent * e);
private slots:
  void setCurrentRing(int index);
  void removeRing(int index);
  void addRing();
  void setRingName(int index, QString name);
private:
  int emptyRingCount() const;
  int addRing(const AutocorrRing& ring);
  void loadTarget(QString fileName);
  void loadCap(QString fileName);
  void loadCapError(QTextStream& s);
  void loadNaViewerReport(QString fileName);
  virtual bool loadMultiColumns(const ColumnTextParser * parser, const QString& fileName);

  RingBrowser * _rings;
  GraphicSheet * _sheet;
  QVector<TextEdit *> _ringLabels;
  QVector<LineLayer *> _ringLayers;
};

#endif // AUTOCORRTARGETWIDGET_H
