/***************************************************************************
**
**  This file is part of dinver.
**
**  dinver is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  dinver is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2005-10-31
**  Copyright: 2005-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QtGui>
#include <QGpGuiTools.h>
#include <DinverCore.h>

#include "PSViewer.h"

class ThreadLauncher;
class ProcessStatus;

class MainWindow : public MultiDocumentWindow
{
  Q_OBJECT
public:
  MainWindow(QWidget* parent=nullptr);
  ~MainWindow();

  static QString pluginSelector(QString tag, bool debug);
  bool setPlugin(QString pluginFile);

  ThreadTimer& bigBen() {return _bigBen;}

  ProcessStatus * status() const {return _status;}
  LogWidget * logs() const {return _logs;}
  ThreadLauncher * runs() const {return _runs;}

  PSViewerList psViewerList() {return findChildren<PSViewer *>();}
  void addThread(InversionThread * t);
  void removeThread(InversionThread * t);
  void clearThread(InversionThread * t);
  QStringList selectedReports(const QString& title) const;
  QList<const AbstractForward *> forwardList(const QStringList& reports) const;
  ThreadList threads() const {return _threads;}
  ThreadList threads(QString t) const;
  ThreadList selectedThreads(bool& allOfTheSameType) const;

  virtual bool useProgress() {return true;}
  virtual AbstractProgress * progress() {return _progressBar;}
  bool closeAllPSViewers();

  QDir currentReportDir() const;

  DinverInterface * plugin() const {return _plugin;}

  void setModified(bool m) {_modified=m;}
  bool isModified() const {return _modified;}
public slots:
  void setToolsMenuState();
  // File menu
  bool clear();
  void open(QString fileName=QString());
  virtual void openDocument(const QString& fileName) {open(fileName);}
  void save();
  void saveAs(QString fileName=QString());
  void importTargets(QString fileName=QString());
  void exportTargets(QString fileName=QString());
  void importParameters(QString fileName=QString());
  void exportParameters(QString fileName=QString());
  // View menu
  void viewPS();

  void setProgressMaximum(int);
  int progressMaximum();
  void setProgressValue(int);
  void showMessage(QString);
private slots:
  void setCurrentRuns(ThreadList tList);
signals:
  void beginClearThreads();
  void endClearThreads();
  void beginNewThread();
  void endNewThread();
  void beginRemoveThread(int index);
  void endRemoveThread();
  void pluginsReady();
protected:
  void setTempDir(const QDir& d);
  void cleanTempDir();
  bool stopAll ();
  bool warnBeforeClose();
  virtual void closeEvent (QCloseEvent * e);
  void addDocks(DockWidget * leftDock, DockWidget * bottomDock);
  void addActions();
  void setWindowsMenuEnabled(bool b);
  void addFileActions();
  void addViewActions();
  void addRunsActions();
  void addToolsActions();
  QAction * windowsMenuAction(QWidget * w);
  QList<PSViewer *> psViewers();

  ThreadTimer _bigBen;
  ThreadList _threads;

  ThreadLauncher * _runs;
  LogWidget * _logs;
  ProcessStatus * _status;
  ProgressBar * _progressBar;

  QString _currentFile;
  TemporaryDirectory _tempDir;

  QMenu * _toolsMenu;
  QAction * _importTargetsAction;
  QAction * _importParamsAction;
  QAction * _showRunAction;
  DockWidget * _targetDock;
  DockWidget * _paramDock;

  DinverInterface * _plugin;
  bool _modified;
};

#endif // MAINWINDOW_H
