/***************************************************************************
**
**  This file is part of dinver.
**
**  dinver is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  dinver is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2006-04-01
**  Copyright: 2006-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <QGpCoreTools.h>

#include "LaunchThreadTable.h"
#include "MainWindow.h"
#include "WindowEnvironment.h"

LaunchThreadTable::LaunchThreadTable(QWidget * parent)
    : QTableView(parent)
{
  TRACE;
}

ThreadList LaunchThreadTable::selectedThreads(bool& allOfTheSameType)
{
  TRACE;
  ThreadList selThreads;
  int n=WindowEnvironment::window(this)->threads().count();
  InversionThread * tRef=nullptr;
  allOfTheSameType=true;

  for(int i=0;i < n;i++ ) {
    if(isThreadSelected( i) ) {
      InversionThread * t=WindowEnvironment::window(this)->threads().at(i);
      if(tRef==nullptr) {
        tRef=t;
      } else if(*t!=*tRef) {
        allOfTheSameType=false;
      }
      selThreads << t;
    }
  }
  return selThreads;
}

InversionThread * LaunchThreadTable::currentEditableThread()
{
  TRACE;
  QModelIndex index=currentIndex();
  if(index.isValid()) {
    InversionThread * t=static_cast<InversionThread *>(index.internalPointer());
    if(t->isRunning()) {
      Message::warning(MSG_ID,tr("Editing thread"),
                          tr("Cannot edit a running process"), Message::cancel());
      return nullptr;
    } else {
      return t;
    }
  } else {
    return nullptr;
  }
}
