/***************************************************************************
**
**  This file is part of campbelltob3.
**
**  campbelltob3 is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  campbelltob3 is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2015-12-18
**  Copyright: 2015-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef PLUGIN_H
#define PLUGIN_H

#include <GeopsyGui.h>

class Plugin : public GeopsyGuiInterface
{
  Q_OBJECT
#if(QT_VERSION > QT_VERSION_CHECK(5, 0, 0))
  Q_PLUGIN_METADATA(IID "org.geopsy.geopsyInterface")
#endif
  Q_INTERFACES(GeopsyCore::GeopsyCoreInterface)
public:
  QString tag() const {return "campbelltob3";}
  QString title() const {return tr("Campbell TOB3 support");}
  QString description() const {return tr("A module to load Campbell TOB3 files, written for CR6");}

  const char * interfaceVersion() const;

  QList<QAction *> createImportActions(QWidget * parent) const;
private slots:
  void import();
};

#endif // PLUGIN_H
