/***************************************************************************
**
**  This file is part of WaranCore.
**
**  WaranCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  WaranCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2009-07-22
**  Copyright: 2009-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef TCPHEADER_H
#define TCPHEADER_H

#include "WaranCoreDLLExport.h"

namespace WaranCore {

class WARANCORE_EXPORT TcpHeader
{
public:
  TcpHeader(unsigned char currentVersion, unsigned char type=0);
  TcpHeader(const TcpHeader& o);

  void operator=(const TcpHeader& o);

  bool isValid() const {return _tag1=='W' && _tag2=='A';}
  bool isCompatible(unsigned char currentVersion) const {return _version<=currentVersion;}
  unsigned char type() const {return _type;}
private:
  char _tag1;
  char _tag2;
  unsigned char _version;
  unsigned char _type;
};

} // namespace WaranCore

#endif // TCPHEADER_H
