/***************************************************************************
**
**  This file is part of TapePositioningSystem.
**
**  TapePositioningSystem is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  TapePositioningSystem is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2012-11-15
**  Copyright: 2012-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef NODE_H
#define NODE_H

#include <QtCore>

#include "TapePositioningSystemDLLExport.h"

namespace TapePositioningSystem {

  class Cluster;

  class TAPEPOSITIONINGSYSTEM_EXPORT Node
  {
  public:
    void setName(const QString& n) {_name=n;}
    const QString& name() const {return _name;}

    void addDistance(Node * to, double value);
    QList<Node *> connections() const {return _distances.keys();}
    int connectionCount() const {return _distances.count();}
    bool isConnected(Node * to) const {return _distances.contains(to);}
    double distance(Node * to) const;

    QList<Cluster *> robustQuads(double stddev);
    const QMap <Node *, double>& distances() const {return _distances;}
  private:
    Cluster * createRobustQuad(QList<Node *> neighbors, double stddev);

    QString _name;
    QMap <Node *, double> _distances;
  };

} // namespace TapePositioningSystem

#endif // NODE_H
