/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2018-11-22
**  Copyright: 2018-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "Ticks.h"
#include "Axis.h"

namespace SciFigs {

  /*!
    \class Ticks Ticks.h
    \brief Brief description of class still missing

    Full description of class still missing
  */
#if 0
  /*!
    Description of constructor still missing
  */
  Ticks::Ticks()
  {
    TRACE;
  }

  /*!
    Description of destructor still missing
  */
  Ticks::~Ticks()
  {
    TRACE;
  }

  void Ticks::update(const Axis& axis)
  {
    TRACE;
    _majors.clear();
    _minors.clear();
    _labels.clear();
    switch(axis._numberType) {
    case Number::Date:
      updateDate(axis);
      break;
    case Number::Weeks:
    case Number::Days:
      break;
    }
  }

  void Ticks::updateDate(const Axis& axis)
  {
    TRACE;
    const Scale& scl=axis.constScale();
    double delta=axis.maximum()-axis.minimum();
    QString format;
    double end, val, x, ticks, invTicks;
    scl.minimum()
    if(delta<=21600) {
      if(delta<=300) {
        if(delta<=180) {
          format="sz's'";                                // Less than 180 s
          ticks=scl.majorTicks();
          invTicks=1.0/ticks;
          end=scl.maximum()*invTicks;
          for(double i=ceil(scl.minimum()*invTicks); i<=end; i++) {
            val=i*ticks;
            _majors.append(axis.r2s(val));
            _labels.append(axis.dateToString(val, format));
          }
        } else {
          format="mm:ss";        // Between 180 s and 300 s
        }
      } else {
        if(delta<=3600) {
          format="m'm'";         // Between 300 s and 3600 s
        } else {
          format="hh:mm";        // Between 3600 s and 21600 s (6h)
        }
      }
    } else {
      if(delta<=86400) {
        format="h'h'";           // Between 21600 s (6h) and 86400 s (24h)
      } else {
        if(delta<=9676800) {
          if(delta<=345600) {
            format="ddd h'h'";   // Between 86400 s (1d) and 345600 s (4d)
          } else {
            format="MMM-dd";     // Between 345600 s (4d) and 9676800 s (16w)
          }
        } else {
          if(delta<=619315200) {
            format="yy-MMM";     // Between 9676800 s (16w) and 619315200 s (19y)
          } else {
            format="yyyy";       // Greater than 619315200 s (19y)
          }
        }
      }
    }
  }

  void Ticks::linear(double min, double max, double ticks)
  {
    double invTicks=1.0/ticks;
    double end=max*invTicks;
    double val;
    for(double i=ceil(min*invTicks); i<=end; i++) {
      val=i*ticks;
      _majors.append(r2s(val));
      _labels.append(axis.dateToString(val));
    }
  }
#endif

} // namespace SciFigs
